/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.services;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.condition.IngredientConditions;
import com.blamejared.crafttweaker.api.ingredient.transformer.IngredientTransformers;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.loot.modifier.ILootModifier;
import com.blamejared.crafttweaker.api.mod.Mod;
import com.blamejared.crafttweaker.api.mod.PlatformMod;
import com.blamejared.crafttweaker.api.recipe.handler.helper.CraftingTableRecipeConflictChecker;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.villager.trade.type.IBasicItemListing;
import com.blamejared.crafttweaker.mixin.common.access.item.AccessIngredient;
import com.blamejared.crafttweaker.platform.helper.inventory.IInventoryWrapper;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3962;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import net.minecraft.class_8144;
import net.minecraft.class_9326;

public interface IPlatformHelper {
    default public String getLogFormat() {
        return "[%d{HH:mm:ss.SSS}][%level][%markerSimpleName]: %msg%n%throwable";
    }

    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    public boolean isDataGen();

    public List<Mod> getMods();

    public Optional<Mod> getMod(String var1);

    public IItemStack createItemStack(class_1799 var1, IngredientConditions var2, IngredientTransformers var3);

    public IItemStack createItemStackMutable(class_1799 var1, IngredientConditions var2, IngredientTransformers var3);

    public IFluidStack createFluidStack(class_3611 var1, long var2, class_9326 var4);

    public IFluidStack createFluidStackMutable(class_3611 var1, long var2, class_9326 var4);

    public <T> IFluidStack createFluidStack(T var1);

    public <T> IFluidStack createFluidStackMutable(T var1);

    public class_3611 getBucketContent(class_1755 var1);

    public Path getGameDirectory();

    public <T extends Annotation> Stream<? extends Class<?>> findClassesWithAnnotation(Class<T> var1, Consumer<PlatformMod> var2, Predicate<Either<T, Map<String, Object>>> var3);

    default public String findMappedMethodName(Class<?> clazz, String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        return methodName;
    }

    default public String findMappedFieldName(Class<?> clazz, String fieldName, Class<?> fieldType) {
        return fieldName;
    }

    public Map<class_2960, ILootModifier> getLootModifiersMap();

    public IInventoryWrapper getPlayerInventory(class_1657 var1);

    @Deprecated(forRemoval=true)
    default public boolean doCraftingTableRecipesConflict(IRecipeManager<?> manager, class_1860<?> first, class_1860<?> second) {
        return CraftingTableRecipeConflictChecker.checkConflicts(manager, first, second);
    }

    public Set<class_5250> getFluidsForDump(class_1799 var1, class_1657 var2, class_1268 var3);

    public class_2487 getCustomData(class_1297 var1);

    public class_2487 getPersistentData(class_3222 var1);

    public boolean doesIngredientRequireTesting(class_1856 var1);

    default public void invalidateIngredients(List<class_1856> ingredients) {
        ingredients.forEach(ingredient -> ((AccessIngredient)ingredient).crafttweaker$setItemStacks(null));
        ingredients.clear();
    }

    default public IItemStack getRemainingItem(class_1799 stack) {
        return (IItemStack)class_8144.method_49078((Object)stack.method_7909().method_7858(), IItemStack::of, (Object)IItemStack.empty());
    }

    public class_1856 getIngredientAny();

    public class_1856 getIngredientList(List<class_1856> var1);

    public class_1856 getCraftTweakerIngredient(IIngredient var1);

    public class_1856 getIItemStackIngredient(IItemStack var1);

    public boolean isCustomIngredient(class_1856 var1);

    default public Stream<class_1799> getCustomIngredientItems(class_1856 ingredient) {
        return Arrays.stream(ingredient.method_8105());
    }

    public Stream<GameProfile> fakePlayers();

    public boolean isFakePlayer(class_1657 var1);

    default public class_1799 getBasicTradePrice(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get price for '%s'".formatted(internal));
    }

    default public class_1799 getBasicTradePrice2(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get price2 for '%s'".formatted(internal));
    }

    default public class_1799 getBasicTradeForSale(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get forSale for '%s'".formatted(internal));
    }

    default public int getBasicTradeMaxTrades(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get maxTrades for '%s'".formatted(internal));
    }

    default public int getBasicTradeXp(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get xp for '%s'".formatted(internal));
    }

    default public float getBasicTradePriceMult(IBasicItemListing internal) {
        throw new UnsupportedOperationException("Unable to get priceMult for '%s'".formatted(internal));
    }

    public class_4174.class_9423 createPossibleEffect(class_1293 var1, float var2);

    default public void setCompostable(IItemStack stack, Optional<Float> value, boolean undoing) {
        class_1792 item = stack.getInternal().method_7909();
        value.ifPresentOrElse(val -> class_3962.field_17566.put((Object)item, val.floatValue()), () -> class_3962.field_17566.removeFloat((Object)item));
    }
}

